import numpy as np
import matplotlib.pyplot as plt

k1 = 5e5 # s-1
k2 = 1e-9 # cm3/s
k3 = 1e-26 # cm6/s
G = 2.65e21# Photons/cm3 s

coefs = [-k3, -k2, -k1, G]
n0 = [x for x in np.roots(coefs) if np.isreal(x) and x > 0]
print(f'Carrier density = {np.real(n0)[0]:.2e} cm-3')

k1 = np.logspace(0, 9)*1e5
n0 = []
for k in k1:
    coefs = [-k3, -k2, -k, G]
    n0.append([x for x in np.roots(coefs) if np.isreal(x) and x > 0])

fig, ax = plt.subplots(figsize=(8,6))

ax.loglog(k1, n0)
ax.set_xlabel('k1 (1/s)');
ax.set_ylabel(f'n (1/cm3)');